<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Unit;
use App\Models\Product;

class UnitController extends Controller
{
    public function index()
    {
        $units = Unit::orderBy('name')->paginate(10);
        return Inertia::render('Admin/Units', ['units' => $units]);
    }

    public function create()
    {
        return Inertia::render('Admin/Units/Create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'symbol' => 'nullable|string|max:10',
        ]);

        Unit::create($data);

        return redirect()->route('admin.units.index')->with('success', 'Unit created successfully.');
    }

    public function destroy($id)
    {
        $unit = Unit::findOrFail($id);
        
        $products = Product::where('unit_id', $unit->id)->pluck('name')->toArray();
        
        if (!empty($products)) {
            return redirect()->route('admin.units.index')->with('error', 'Cannot delete unit; related products: ' . implode(', ', $products) . '.');
        }

        $unit->delete();
        return redirect()->route('admin.units.index')->with('success', 'Unit deleted successfully.');
    }
}
