<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Deal extends Model
{
    protected $fillable = [
        'product_id', 'title', 'description', 'original_price', 'deal_price', 
        'sold_quantity', 'available_quantity', 'start_date', 'end_date', 'is_active'
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'is_active' => 'boolean'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function getProgressPercentageAttribute()
    {
        $total = $this->sold_quantity + $this->available_quantity;
        return $total > 0 ? round(($this->sold_quantity / $total) * 100) : 0;
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true)
                    ->where('start_date', '<=', now())
                    ->where('end_date', '>=', now());
    }
}
