<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Voucher extends Model
{
    protected $fillable = [
        'voucher_number',
        'type',
        'source',
        'amount',
        'description',
        'reference',
        'order_id'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public static function generateVoucherNumber($type)
    {
        $prefix = $type === 'cash_in' ? 'CI' : 'CO';
        return $prefix . '-' . date('Y') . '-' . str_pad(static::count() + 1, 6, '0', STR_PAD_LEFT);
    }
}
