<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Inventory Management
            $table->integer('stock_quantity')->default(0);
            $table->integer('low_stock_threshold')->default(10);
            $table->enum('stock_status', ['in_stock', 'out_of_stock', 'low_stock'])->default('in_stock');
            
            // Product Status & Visibility
            $table->enum('status', ['active', 'inactive', 'draft'])->default('active');
            $table->boolean('is_featured')->default(false);
            $table->enum('visibility', ['public', 'private', 'hidden'])->default('public');
            
            // Enhanced Product Information
            $table->text('description')->nullable();
            $table->text('short_description')->nullable();
            $table->decimal('weight', 8, 2)->nullable();
            $table->string('dimensions')->nullable();
            $table->string('barcode')->nullable();
            
            // Pricing Features
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('tax_rate', 5, 2)->default(0);
            
            // SEO & Marketing
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('tags')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'stock_quantity', 'low_stock_threshold', 'stock_status',
                'status', 'is_featured', 'visibility',
                'description', 'short_description', 'weight', 'dimensions', 'barcode',
                'discount_price', 'tax_rate',
                'meta_title', 'meta_description', 'tags'
            ]);
        });
    }
};
