<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Create permissions
        $permissions = [
            ['name' => 'manage_brands', 'display_name' => 'Manage Brands'],
            ['name' => 'manage_categories', 'display_name' => 'Manage Categories'],
            ['name' => 'manage_subcategories', 'display_name' => 'Manage Subcategories'],
            ['name' => 'manage_units', 'display_name' => 'Manage Units'],
            ['name' => 'manage_products', 'display_name' => 'Manage Products'],
            ['name' => 'manage_orders', 'display_name' => 'Manage Orders'],
            ['name' => 'manage_reports', 'display_name' => 'Manage Reports'],
            ['name' => 'manage_roles', 'display_name' => 'Manage Roles'],
            ['name' => 'manage_users', 'display_name' => 'Manage Users'],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission['name']], $permission);
        }

        // Create Master role (cannot be deleted)
        $masterRole = Role::firstOrCreate(['name' => 'Master']);
        
        // Create User role
        $userRole = Role::firstOrCreate(['name' => 'User']);

        // Assign all permissions to Master role
        $masterRole->permissions()->sync(Permission::all());

        // Create master admin user
        User::firstOrCreate(
            ['email' => 'admin@adminacc.com'],
            [
                'name' => 'Master Admin',
                'password' => Hash::make('password'),
                'role_id' => $masterRole->id,
                'email_verified_at' => now(),
            ]
        );
    }
}
