@extends('frontend.home')
@section('content')
      <main>
         <section class="mt-8">
            <div class="container">
               <div class="hero-slider">
                  <div style="background: url({{ asset('assets/images/slider/hero-img-slider-1.jpg') }}) no-repeat; background-size: cover; border-radius: 0.5rem; background-position: center">
                     <div class="ps-lg-12 py-lg-16 col-xxl-5 col-lg-7 col-md-8 py-14 px-8 text-xs-center">
                        <h1 class="text-white display-5 fw-bold mt-4">SuperMarket For Fresh Grocery</h1>
                        <p class="lead text-white">Introduced a new model for online grocery shopping and convenient home delivery at any time.</p>
                        <a href="#!" class="btn btn-dark mt-3">
                           Shop Now
                           <i class="feather-icon icon-arrow-right ms-1"></i>
                        </a>
                     </div>
                  </div>
                  <div style="background: url({{ asset('assets/images/slider/hero-img-slider-2.jpg') }}) no-repeat; background-size: cover; border-radius: 0.5rem; background-position: center">
                     <div class="ps-lg-12 py-lg-16 col-xxl-5 col-lg-7 col-md-8 py-14 px-8 text-xs-center">
                        <h1 class="text-dark display-5 fw-bold mt-4">
                           Opening Sale
                           <br />
                           Discount up to
                           <span class="text-primary display-6">50%</span>
                        </h1>
                        <p class="lead">Snack on late-night munchies of delicious nuts & you're guaranteed happiness before you doze!</p>
                        <a href="#!" class="btn btn-dark mt-3">
                           Shop Now
                           <i class="feather-icon icon-arrow-right ms-1"></i>
                        </a>
                     </div>
                  </div>
                  <div style="background: url({{ asset('assets/images/slider/hero-img-slider-3.jpg') }}) no-repeat; background-size: cover; border-radius: 0.5rem; background-position: center">
                     <div class="ps-lg-12 py-lg-16 col-xxl-5 col-lg-7 col-md-8 py-14 px-8 text-xs-center">
                        <h1 class="text-dark display-5 fw-bold mt-4">Midnight Munch Combo</h1>
                        <p class="lead">Snack on late-night munchies of delicious nuts & you're guaranteed happiness before you doze!</p>
                        <a href="#!" class="btn btn-dark mt-3">
                           Shop Now
                           <i class="feather-icon icon-arrow-right ms-1"></i>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </section>

         <div class="mt-lg-12 mb-lg-14 mb-8">
            <!-- container -->
            <div class="container">
               <!-- row -->
               <div class="row">
                  <!-- col -->
                  <aside class="col-xl-3 col-lg-4 col-md-4 mb-6 mb-md-0">
                     <div id="sidebar">
                        <div class="sidebar__inner">
                           <div class="offcanvas offcanvas-start offcanvas-collapse" tabindex="-1" id="offcanvasCategory" aria-labelledby="offcanvasCategoryLabel">
                              <div class="offcanvas-header d-lg-none">
                                 <h5 class="offcanvas-title" id="offcanvasCategoryLabel">Filter</h5>
                                 <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                              </div>
                              <div class="offcanvas-body p-lg-0">
                                 <div class="mb-4">
                                    <!-- title -->
                                    <h3 class="mb-4 h5">Categories</h3>
                                    <!-- nav -->
                                    <div class="card">
                                       <ul class="nav nav-category" id="categoryCollapseMenu">
                                          @foreach($categories as $category)
                                          <li class="nav-item border-bottom w-100 collapsed px-4 py-1">
                                             <a
                                                href="javascript:void(0)"
                                                class="nav-link"
                                                data-bs-toggle="collapse"
                                                data-bs-target="#categoryFlush{{ $category->id }}"
                                                aria-expanded="false"
                                                aria-controls="categoryFlush{{ $category->id }}">
                                                <span class="d-flex align-items-center">
                                                   @if($category->image)
                                                      <img src="{{ asset('storage/' . $category->image) }}" alt="{{ $category->name }}" width="24" height="24" class="rounded">
                                                   @else
                                                      <div style="width: 24px; height: 24px; background: #f3f4f6; border-radius: 4px;"></div>
                                                   @endif
                                                   <span class="ms-2">
                                                      {{ $category->name }}
                                                      @if($category->brand && $categories->where('name', $category->name)->count() > 1)
                                                         ({{ $category->brand->name }})
                                                      @endif
                                                   </span>
                                                </span>
                                                @if($category->subcategories->count() > 0)
                                                <i class="feather-icon icon-chevron-right"></i>
                                                @endif
                                             </a>
                                             @if($category->subcategories->count() > 0)
                                             <div id="categoryFlush{{ $category->id }}" class="accordion-collapse collapse" data-bs-parent="#categoryCollapseMenu">
                                                <div>
                                                   <ul class="nav flex-column ms-8">
                                                      @foreach($category->subcategories as $subcategory)
                                                      <li class="nav-item"><a href="javascript:void(0)" class="nav-link">{{ $subcategory->name }}</a></li>
                                                      @endforeach
                                                   </ul>
                                                </div>
                                             </div>
                                             @endif
                                          </li>
                                          @endforeach
                                          <!-- nav item -->
                                       </ul>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </aside>
                  <div class="col-xl-9 col-lg-8 col-md-12 mb-6 mb-md-0">
                     <div class="mb-12 product-content">
                        <div class="mb-6">
                           <h3 class="mb-0">New Arrivals</h3>
                        </div>
                        <div class="product-slider-four-column">
                        @foreach($recentProducts as $product)
                            <div class="item">
                                <div class="card card-product mb-4">
                                    <div class="card-body text-center py-8">
                                    <a href="{{ route('product.show', $product->id) }}">
                                        @if($product->image)
                                            <img src="{{ asset('storage/' . $product->image) }}"
                                                alt="{{ $product->name }}"
                                                class="mb-3"
                                                style="max-height: 150px; object-fit: cover;" />
                                        @else
                                            <div class="mb-3 d-flex align-items-center justify-content-center"
                                                style="width:150px;height:150px;background:#f8f9fa;border-radius:8px;margin:auto;">
                                                <span class="text-muted">No Image</span>
                                            </div>
                                        @endif
                                    </a>
                                    </div>
                                </div>

                                <div>
                                    @if($product->discount_price)
                                    @php
                                        $discount = round((($product->price - $product->discount_price) / $product->price) * 100);
                                    @endphp
                                    <span class="badge bg-danger rounded-pill">-{{ $discount }}%</span>
                                    @endif

                                    <h2 class="mt-3 fs-6">
                                    <a href="{{ route('product.show', $product->id) }}" class="text-inherit">{{ $product->name }}</a>
                                    </h2>

                                    <div>
                                    <span class="text-dark fs-5 fw-bold">৳{{ $product->final_price }}</span>
                                    @if($product->discount_price)
                                        <span class="text-decoration-line-through text-muted">৳{{ $product->price }}</span>
                                    @endif
                                    @if($product->unit && (strtolower($product->unit->name) == 'kg' || strtolower($product->unit->name) == 'kilogram'))
                                        <br><small class="text-muted">৳{{ number_format(($product->discount_price ?: $product->price), 2) }}/kg</small>
                                    @elseif($product->unit && strtolower($product->unit->name) == 'litre')
                                        <br><small class="text-muted">৳{{ number_format(($product->discount_price ?: $product->price), 2) }}/litre</small>
                                    @endif
                                    </div>

                                    <div class="text-warning">
                                    <small>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-half"></i>
                                    </small>
                                    <span class="text-muted small">4.5</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        </div>

                     </div>
                     @if($activeDeal)
                     <div class="mb-6">
                        <div class="mb-6">
                           <h3 class="mb-1">Deal of the day</h3>
                           <p>{{ $activeDeal->description ?: 'Brings to users an array of discounts on a variety' }}</p>
                        </div>
                        <div class="card border border-danger p-6">
                           <div class="row">
                              <div class="col-lg-5 text-center">
                                 <a href="{{ route('product.show', $activeDeal->product->id) }}">
                                    @if($activeDeal->product->image)
                                       <img src="{{ asset('storage/' . $activeDeal->product->image) }}" alt="{{ $activeDeal->product->name }}" class="img-fluid" />
                                    @else
                                       <img src="{{ asset('assets/images/products/deal-img.jpg') }}" alt="{{ $activeDeal->product->name }}" class="img-fluid" />
                                    @endif
                                 </a>
                              </div>
                              <div class="col-lg-7 text-center text-lg-start">
                                 <div class="mb-3">
                                    <small class="text-warning">
                                       <i class="bi bi-star-fill"></i>
                                       <i class="bi bi-star-fill"></i>
                                       <i class="bi bi-star-fill"></i>
                                       <i class="bi bi-star-fill"></i>
                                       <i class="bi bi-star-half"></i>
                                    </small>
                                    <span><small>4.5</small></span>
                                 </div>
                                 <h2 class="fs-4"><a href="{{ route('product.show', $activeDeal->product->id) }}" class="text-inherit text-decoration-none">{{ $activeDeal->title }}</a></h2>

                                 <div class="d-flex justify-content-center align-items-center justify-content-lg-between mt-3">
                                    <div>
                                       <span class="text-dark fs-5 fw-bold">৳{{ $activeDeal->deal_price }}</span>
                                       <span class="text-decoration-line-through text-muted fs-5">৳{{ $activeDeal->original_price }}</span>
                                    </div>
                                 </div>
                                 <div class="mt-2">
                                    <button type="button" class="btn btn-primary" onclick="addDealToCart({{ $activeDeal->product->id }}, 1)">
                                       <svg
                                          xmlns="http://www.w3.org/2000/svg"
                                          width="16"
                                          height="16"
                                          viewBox="0 0 24 24"
                                          fill="none"
                                          stroke="currentColor"
                                          stroke-width="2"
                                          stroke-linecap="round"
                                          stroke-linejoin="round"
                                          class="feather feather-plus">
                                          <line x1="12" y1="5" x2="12" y2="19"></line>
                                          <line x1="5" y1="12" x2="19" y2="12"></line>
                                       </svg>
                                       Add to cart
                                    </button>
                                 </div>
                                 <div class="mt-6 mb-6">
                                    <div class="d-flex justify-content-between mb-2">
                                       <span>
                                          Already Sold:
                                          <span class="text-dark fs-6 fw-bold">{{ $activeDeal->sold_quantity }}</span>
                                       </span>
                                       <span>
                                          Available:
                                          <span class="text-dark fs-6 fw-bold">{{ $activeDeal->available_quantity }}</span>
                                       </span>
                                    </div>

                                    <div class="progress bg-light-danger" role="progressbar" aria-label="Deal progress" aria-valuenow="{{ $activeDeal->progress_percentage }}" aria-valuemin="0" aria-valuemax="100" style="height: 5px">
                                       <div class="progress-bar bg-danger" style="width: {{ $activeDeal->progress_percentage }}%"></div>
                                    </div>
                                 </div>
                                 <p class="fw-bold text-dark mb-0">Hurry up offer ends soon</p>
                                 <div class="d-flex justify-content-center justify-content-lg-start text-center mt-1">
                                    <div class="deals-countdown" data-countdown="{{ $activeDeal->end_date->format('Y/m/d H:i:s') }}"></div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     @endif
                     <div class="bg-light-danger text-danger p-4 rounded bg-opacity-50 text-center mb-12 d-flex align-items-center justify-content-center">
                        <p class="mb-0">
                           First time here? Get 10% off your first order!
                           <span class="link-danger link-underline-danger">Click here</span>
                        </p>
                        <span class="border-dashed border-danger py-1 px-3 text-danger rounded bg-light-danger ms-4">FIRSTTIME10</span>
                     </div>
                     <div class="row">
                        <div class="col-12">
                           <div class="row align-items-center mb-6">
                              <div class="col-xl-10 col-lg-9 col-8">
                                 <div class="mb-4 mb-lg-0">
                                    <h3 class="mb-1">New Products</h3>
                                    <p class="mb-0">Fresh products with updated stocks.</p>
                                 </div>
                              </div>
                              <div class="col-xl-2 col-lg-3 col-4 text-end">
                                 <a href="{{ route('shop-all') }}" class="btn btn-primary">View All</a>
                              </div>
                           </div>
                           <div class="row row-cols-xl-4 row-cols-lg-3 g-4">
                              @foreach($products->take(8) as $product)
                              <div class="col">
                                 <div class="mb-6">
                                    <div class="card card-product mb-4">
                                       <div class="card-body text-center py-8">
                                          <a href="{{ route('product.show', $product->id) }}">
                                             @if($product->image)
                                                <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}" class="mb-3" style="max-height: 120px; object-fit: cover;" />
                                             @else
                                                <img src="{{ asset('assets/images/products/product-img-1.jpg') }}" alt="{{ $product->name }}" class="mb-3" />
                                             @endif
                                          </a>
                                       </div>
                                    </div>
                                    <div>
                                       @if($product->discount_price)
                                          @php
                                             $discount = round((($product->price - $product->discount_price) / $product->price) * 100);
                                          @endphp
                                          <span class="badge bg-danger rounded-pill">-{{ $discount }}%</span>
                                       @endif
                                       <h2 class="mt-3 fs-6"><a href="{{ route('product.show', $product->id) }}" class="text-inherit">{{ $product->name }}</a></h2>
                                       <div>
                                          @if($product->discount_price)
                                             <span class="text-dark fs-5 fw-bold">৳{{ $product->discount_price }}</span>
                                             <span class="text-decoration-line-through text-muted">৳{{ $product->price }}</span>
                                          @else
                                             <span class="text-dark fs-5 fw-bold">৳{{ $product->price }}</span>
                                          @endif
                                          @if($product->unit && (strtolower($product->unit->name) == 'kg' || strtolower($product->unit->name) == 'kilogram'))
                                             <br><small class="text-muted">৳{{ number_format(($product->discount_price ?: $product->price), 2) }}/kg</small>
                                          @elseif($product->unit && strtolower($product->unit->name) == 'litre')
                                             <br><small class="text-muted">৳{{ number_format(($product->discount_price ?: $product->price), 2) }}/litre</small>
                                          @endif
                                       </div>
                                       <div class="text-warning">
                                          <small>
                                             <i class="bi bi-star-fill"></i>
                                             <i class="bi bi-star-fill"></i>
                                             <i class="bi bi-star-fill"></i>
                                             <i class="bi bi-star-fill"></i>
                                             <i class="bi bi-star-half"></i>
                                          </small>
                                          <span class="text-muted small">4.5</span>
                                       </div>
                                       <div class="mt-2">
                                          <button class="btn btn-primary btn-sm" onclick="quickAddToCart({{ $product->id }}, '{{ $product->name }}', {{ $product->discount_price ?: $product->price }}, '{{ $product->image ? asset('storage/' . $product->image) : asset('assets/images/products/product-img-1.jpg') }}')">Add to Cart</button>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              @endforeach
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </main>

      <!-- Modal -->

      <div class="modal fade" id="modal-subscribe" tabindex="-1" aria-hidden="true">
         <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
               <div class="modal-body p-0">
                  <div class="d-flex align-items-center">
                     <div class="d-none d-lg-block">
                        <img src="{{ asset('assets/images/banner/modal_img.jpg') }}" alt="" class="img-fluid rounded-start" />
                     </div>
                     <div class="px-8 py-8 py-lg-0">
                        <div class="position-absolute end-0 top-0 m-6">
                           <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <span class="bg-light-danger text-danger badge rounded-pill mb-4 px-4 py-2">7 Day Super Sale</span>
                        <h2 class="display-6 fw-bold">
                           Discount up to
                           <br />
                           <span class="text-primary">50%</span>
                        </h2>
                        <p class="lead mb-5">Seven day of grate deals - what could be better?</p>

                        <div class="d-grid">
                           <a href="#" class="btn btn-primary" data-bs-dismiss="modal">Start Show Now</a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <!-- modal -->
      
      <script>
      function quickAddToCart(productId, productName, productPrice, productImage) {
          fetch('/cart/add', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
                  'X-CSRF-TOKEN': '{{ csrf_token() }}'
              },
              body: JSON.stringify({
                  product_id: productId,
                  quantity: 1
              })
          })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  alert('Added ' + productName + ' to cart!');
                  if (window.loadCartItems) {
                      window.loadCartItems();
                  }
              }
          })
          .catch(error => {
              console.error('Error:', error);
          });
      }
      
      function addDealToCart(productId, quantity) {
          fetch('/cart/add', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
                  'X-CSRF-TOKEN': '{{ csrf_token() }}'
              },
              body: JSON.stringify({
                  product_id: productId,
                  quantity: quantity
              })
          })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  alert('Deal added to cart!');
                  if (window.loadCartItems) {
                      window.loadCartItems();
                  }
              }
          });
      }
      </script>
@endsection