@extends('frontend.home')
@section('content')
<main>
   <div class="mt-4">
      <div class="container">
         <div class="row">
            <div class="col-12">
               <nav aria-label="breadcrumb">
                  <ol class="breadcrumb mb-0">
                     <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                     <li class="breadcrumb-item active" aria-current="page">Search Results</li>
                  </ol>
               </nav>
            </div>
         </div>
      </div>
   </div>
   
   <section class="mt-8 mb-lg-14 mb-8">
      <div class="container">
         <div class="row">
            <div class="col-12">
               <h1 class="mb-4">Search Results for "{{ $query }}"</h1>
               <p class="mb-6">{{ $products->total() }} products found</p>
            </div>
         </div>
         
         @if($products->count() > 0)
         <div class="row g-4 row-cols-lg-4 row-cols-2 row-cols-md-3">
            @foreach($products as $product)
            <div class="col">
               <div class="card card-product">
                  <div class="card-body">
                     <div class="text-center position-relative">
                        <a href="{{ route('product.show', $product->id) }}">
                           <img src="{{ $product->image ? asset('storage/' . $product->image) : asset('assets/images/products/product-img-1.jpg') }}" alt="{{ $product->name }}" class="mb-3 img-fluid" />
                        </a>
                     </div>
                     <div class="text-small mb-1">
                        <a href="#!" class="text-decoration-none text-muted">
                           <small>{{ $product->category->name ?? 'Category' }}</small>
                        </a>
                     </div>
                     <h2 class="fs-6">
                        <a href="{{ route('product.show', $product->id) }}" class="text-inherit text-decoration-none">{{ $product->name }}</a>
                     </h2>
                     <div class="text-warning">
                        <small>
                           <i class="bi bi-star-fill"></i>
                           <i class="bi bi-star-fill"></i>
                           <i class="bi bi-star-fill"></i>
                           <i class="bi bi-star-fill"></i>
                           <i class="bi bi-star-half"></i>
                        </small>
                        <span class="text-muted small">4.5(149)</span>
                     </div>
                     <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                           <span class="text-dark">৳{{ $product->discount_price ?: $product->price }}</span>
                           @if($product->discount_price)
                              <span class="text-decoration-line-through text-muted">৳{{ $product->price }}</span>
                           @endif
                        </div>
                        <div>
                           <a href="#!" class="btn btn-primary btn-sm">
                              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus">
                                 <line x1="12" y1="5" x2="12" y2="19"></line>
                                 <line x1="5" y1="12" x2="19" y2="12"></line>
                              </svg>
                              Add
                           </a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            @endforeach
         </div>
         
         <div class="row mt-8">
            <div class="col">
               {{ $products->appends(['q' => $query])->links() }}
            </div>
         </div>
         @else
         <div class="row">
            <div class="col-12 text-center">
               <div class="my-8">
                  <h3>No products found</h3>
                  <p class="text-muted">Try searching with different keywords or browse our categories.</p>
                  <a href="{{ route('home') }}" class="btn btn-primary">Back to Home</a>
               </div>
            </div>
         </div>
         @endif
      </div>
   </section>
</main>
@endsection