@extends('frontend.home')
@section('content')
    <main>
        <div class="mt-4">
            <div class="container">
               <!-- row -->
               <div class="row">
                  <!-- col -->
                  <div class="col-12">
                     <!-- breadcrumb -->
                     <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                           <li class="breadcrumb-item"><a href="{{ route('home') }}"">Home</a></li>
                           <li class="breadcrumb-item"><a href="#">Shop</a></li>
                        </ol>
                     </nav>
                  </div>
               </div>
            </div>
        </div>
        <!-- section -->
        <section class="mt-8 mb-lg-14 mb-8">
            <div class="container">
                <!-- row -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card mb-4 bg-light border-0">
                        <div class="card-body p-9">
                            <h2 class="mb-0 fs-1">All Product</h2>
                        </div>
                        </div>
                        <div class="d-lg-flex justify-content-between align-items-center">
                        <div>
                            <p class="mb-3 mb-md-0">
                                <span class="text-dark">{{ $products->total() }}</span>
                                Products found
                            </p>
                        </div>
                        <div class="d-md-flex justify-content-between align-items-center">
                            <div class="me-3">
                                <button class="btn btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#filterCollapse">
                                    <i class="bi bi-funnel"></i> Filters
                                </button>
                            </div>
                            <div class="d-flex mt-2 mt-lg-0">
                                <div class="me-2 flex-grow-1">
                                    <select class="form-select" onchange="updatePerPage(this.value)">
                                    <option value="12" {{ request('per_page', 12) == 12 ? 'selected' : '' }}>Show: 12</option>
                                    <option value="24" {{ request('per_page') == 24 ? 'selected' : '' }}>Show: 24</option>
                                    <option value="48" {{ request('per_page') == 48 ? 'selected' : '' }}>Show: 48</option>
                                    </select>
                                </div>
                                <div>
                                    <select class="form-select" onchange="updateSort(this.value)">
                                    <option value="" {{ !request('sort') ? 'selected' : '' }}>Sort by: Featured</option>
                                    <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Price: Low to High</option>
                                    <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price: High to Low</option>
                                    <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>Name: A to Z</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        </div>
                        <div class="collapse mt-3" id="filterCollapse">
                            <div class="card card-body">
                                <form method="GET" action="{{ route('shop-all') }}" class="row g-3">
                                    <div class="col-md-3">
                                        <label class="form-label">Category</label>
                                        <select name="category" class="form-select">
                                            <option value="">All Categories</option>
                                            @foreach($categories as $category)
                                            <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                                {{ $category->name }}@if($category->brand) ({{ $category->brand->name }})@endif
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label">Brand</label>
                                        <select name="brand" class="form-select">
                                            <option value="">All Brands</option>
                                            @foreach($brands as $brand)
                                            <option value="{{ $brand->id }}" {{ request('brand') == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Min Price</label>
                                        <input type="number" name="min_price" class="form-control" value="{{ request('min_price') }}" placeholder="0">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label">Max Price</label>
                                        <input type="number" name="max_price" class="form-control" value="{{ request('max_price') }}" placeholder="1000">
                                    </div>
                                    <div class="col-md-2 d-flex align-items-end">
                                        <button type="submit" class="btn btn-primary me-2">Apply</button>
                                        <a href="{{ route('shop-all') }}" class="btn btn-outline-secondary">Clear</a>
                                    </div>
                                    <input type="hidden" name="sort" value="{{ request('sort') }}">
                                    <input type="hidden" name="per_page" value="{{ request('per_page') }}">
                                </form>
                            </div>
                        </div>
                        <div class="row g-4 row-cols-lg-5 row-cols-2 row-cols-md-3 mt-2">
                        @foreach($products as $product)
                        <div class="col">
                            <div class="card card-product">
                                <div class="card-body">
                                    <div class="text-center position-relative">
                                    @if($product->discount_price)
                                        <div class="position-absolute top-0 start-0">
                                            <span class="badge bg-danger">Sale</span>
                                        </div>
                                    @endif
                                    <a href="{{ route('product.show', $product->id) }}">
                                        @if($product->image)
                                            <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}" class="mb-3 img-fluid" />
                                        @else
                                            <img src="{{ asset('assets/images/products/product-img-1.jpg') }}" alt="{{ $product->name }}" class="mb-3 img-fluid" />
                                        @endif
                                    </a>
                                    </div>
                                    <div class="text-small mb-1">
                                        <a href="#!" class="text-decoration-none text-muted">
                                            <small>{{ $product->category->name }}@if($product->category->brand) ({{ $product->category->brand->name }})@endif</small>
                                        </a>
                                    </div>
                                    <h2 class="fs-6"><a href="{{ route('product.show', $product->id) }}" class="text-inherit text-decoration-none">{{ $product->name }}</a></h2>
                                    <div class="d-flex justify-content-between align-items-center mt-3">
                                    <div>
                                        @if($product->discount_price)
                                            <span class="text-dark">৳{{ $product->discount_price }}</span>
                                            <span class="text-decoration-line-through text-muted">৳{{ $product->price }}</span>
                                        @else
                                            <span class="text-dark">৳{{ $product->price }}</span>
                                        @endif
                                        @if($product->unit && (strtolower($product->unit->name) == 'kg' || strtolower($product->unit->name) == 'kilogram'))
                                            <br><small class="text-muted">৳{{ number_format(($product->discount_price ?: $product->price), 2) }}/kg</small>
                                        @elseif($product->unit && strtolower($product->unit->name) == 'litre')
                                            <br><small class="text-muted">৳{{ number_format(($product->discount_price ?: $product->price), 2) }}/litre</small>
                                        @endif
                                    </div>
                                    <div>
                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#cartModal" data-product-id="{{ $product->id }}" data-product-name="{{ $product->name }}" data-product-price="{{ $product->discount_price ?: $product->price }}" data-product-image="{{ $product->image ? asset('storage/' . $product->image) : asset('assets/images/products/product-img-1.jpg') }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus">
                                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                                <line x1="5" y1="12" x2="19" y2="12"></line>
                                            </svg>
                                            Add
                                        </button>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        </div>
                        <div class="row mt-8">
                            <div class="col">
                                @if($products->hasPages())
                                <nav aria-label="Product pagination">
                                    <ul class="pagination justify-content-center">
                                        @if($products->onFirstPage())
                                            <li class="page-item disabled"><span class="page-link">Previous</span></li>
                                        @else
                                            <li class="page-item"><a class="page-link" href="{{ $products->previousPageUrl() }}">Previous</a></li>
                                        @endif
                                        
                                        @foreach($products->getUrlRange(1, $products->lastPage()) as $page => $url)
                                            @if($page == $products->currentPage())
                                                <li class="page-item active"><span class="page-link">{{ $page }}</span></li>
                                            @else
                                                <li class="page-item"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                                            @endif
                                        @endforeach
                                        
                                        @if($products->hasMorePages())
                                            <li class="page-item"><a class="page-link" href="{{ $products->nextPageUrl() }}">Next</a></li>
                                        @else
                                            <li class="page-item disabled"><span class="page-link">Next</span></li>
                                        @endif
                                    </ul>
                                </nav>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <!-- modal -->
    <!-- Modal -->
    <div class="modal fade" id="quickViewModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body p-8">
                    <div class="position-absolute top-0 end-0 me-3 mt-3">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                        <!-- img slide -->
                        <div class="product productModal" id="productModal">
                            <div class="zoom" onmousemove="zoom(event)" style="background-image: url(../assets/images/products/product-single-img-1.jpg)">
                                <!-- img -->
                                <img src="../assets/images/products/product-single-img-1.jpg" alt="" />
                            </div>
                            <div>
                                <div class="zoom" onmousemove="zoom(event)" style="background-image: url(../assets/images/products/product-single-img-2.jpg)">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-2.jpg" alt="" />
                                </div>
                            </div>
                            <div>
                                <div class="zoom" onmousemove="zoom(event)" style="background-image: url(../assets/images/products/product-single-img-3.jpg)">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-3.jpg" alt="" />
                                </div>
                            </div>
                            <div>
                                <div class="zoom" onmousemove="zoom(event)" style="background-image: url(../assets/images/products/product-single-img-4.jpg)">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-4.jpg" alt="" />
                                </div>
                            </div>
                        </div>
                        <!-- product tools -->
                        <div class="product-tools">
                            <div class="thumbnails row g-3" id="productModalThumbnails">
                                <div class="col-3" class="tns-nav-active">
                                    <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-1.jpg" alt="" />
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-2.jpg" alt="" />
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-3.jpg" alt="" />
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="../assets/images/products/product-single-img-4.jpg" alt="" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                        <div class="col-lg-6">
                        <div class="ps-lg-8 mt-6 mt-lg-0">
                            <a href="#!" class="mb-4 d-block">Bakery Biscuits</a>
                            <h2 class="mb-1 h1">Napolitanke Ljesnjak</h2>
                            <div class="mb-4">
                                <small class="text-warning">
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-half"></i>
                                </small>
                                <a href="#" class="ms-2">(30 reviews)</a>
                            </div>
                            <div class="fs-4">
                                <span class="fw-bold text-dark">৳32</span>
                                <span class="text-decoration-line-through text-muted">৳35</span>
                                <span><small class="fs-6 ms-2 text-danger">26% Off</small></span>
                            </div>
                            <hr class="my-6" />
                            <div class="mb-4">
                                <button type="button" class="btn btn-outline-secondary">250g</button>
                                <button type="button" class="btn btn-outline-secondary">500g</button>
                                <button type="button" class="btn btn-outline-secondary">1kg</button>
                            </div>
                            <div>
                                <!-- input -->
                                <!-- input -->
                                <div class="input-group input-spinner">
                                    <input type="button" value="-" class="button-minus btn btn-sm" data-field="quantity" />
                                    <input type="number" step="1" max="10" value="1" name="quantity" class="quantity-field form-control-sm form-input" />
                                    <input type="button" value="+" class="button-plus btn btn-sm" data-field="quantity" />
                                </div>
                            </div>
                            <div class="mt-3 row justify-content-start g-2 align-items-center">
                                <div class="col-lg-4 col-md-5 col-6 d-grid">
                                    <!-- button -->
                                    <!-- btn -->
                                    <button type="button" class="btn btn-primary">
                                    <i class="feather-icon icon-shopping-bag me-2"></i>
                                    Add to cart
                                    </button>
                                </div>
                                <div class="col-md-4 col-5">
                                    <!-- btn -->
                                    <a class="btn btn-light" href="#" data-bs-toggle="tooltip" data-bs-html="true" aria-label="Compare"><i class="bi bi-arrow-left-right"></i></a>
                                    <a class="btn btn-light" href="#!" data-bs-toggle="tooltip" data-bs-html="true" aria-label="Wishlist"><i class="feather-icon icon-heart"></i></a>
                                </div>
                            </div>
                            <hr class="my-6" />
                            <div>
                                <table class="table table-borderless">
                                    <tbody>
                                    <tr>
                                        <td>Product Code:</td>
                                        <td>FBB00255</td>
                                    </tr>
                                    <tr>
                                        <td>Availability:</td>
                                        <td>In Stock</td>
                                    </tr>
                                    <tr>
                                        <td>Type:</td>
                                        <td>Fruits</td>
                                    </tr>
                                    <tr>
                                        <td>Shipping:</td>
                                        <td>
                                            <small>
                                                01 day shipping.
                                                <span class="text-muted">( Free pickup today)</span>
                                            </small>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Cart Modal -->
    <div class="modal fade" id="cartModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add to Cart</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="d-flex align-items-center">
                        <img id="cartProductImage" src="" alt="" class="me-3" style="width: 80px; height: 80px; object-fit: cover;">
                        <div>
                            <h6 id="cartProductName"></h6>
                            <p class="mb-0 text-muted">Price: ৳<span id="cartProductPrice"></span></p>
                        </div>
                    </div>
                    <div class="mt-3">
                        <label class="form-label">Quantity</label>
                        <div class="input-group" style="width: 150px;">
                            <button class="btn btn-outline-secondary" type="button" onclick="changeQuantity(-1)">-</button>
                            <input type="number" class="form-control text-center" id="cartQuantity" value="1" min="1">
                            <button class="btn btn-outline-secondary" type="button" onclick="changeQuantity(1)">+</button>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="addToCart()">Add to Cart</button>
                </div>
            </div>
        </div>
    </div>
    
    <script>
    function updateSort(sortValue) {
        const url = new URL(window.location);
        if (sortValue) {
            url.searchParams.set('sort', sortValue);
        } else {
            url.searchParams.delete('sort');
        }
        window.location.href = url.toString();
    }
    
    function updatePerPage(perPage) {
        const url = new URL(window.location);
        url.searchParams.set('per_page', perPage);
        window.location.href = url.toString();
    }
    
    let currentProduct = {};
    
    document.addEventListener('DOMContentLoaded', function() {
        const cartModal = document.getElementById('cartModal');
        cartModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            currentProduct = {
                id: button.getAttribute('data-product-id'),
                name: button.getAttribute('data-product-name'),
                price: button.getAttribute('data-product-price'),
                image: button.getAttribute('data-product-image')
            };
            
            document.getElementById('cartProductImage').src = currentProduct.image;
            document.getElementById('cartProductName').textContent = currentProduct.name;
            document.getElementById('cartProductPrice').textContent = currentProduct.price;
            document.getElementById('cartQuantity').value = 1;
        });
    });
    
    function changeQuantity(change) {
        const quantityInput = document.getElementById('cartQuantity');
        let quantity = parseInt(quantityInput.value) + change;
        if (quantity < 1) quantity = 1;
        quantityInput.value = quantity;
    }
    
    function addToCart() {
        const quantity = document.getElementById('cartQuantity').value;
        
        fetch('{{ route('cart.add') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                product_id: currentProduct.id,
                quantity: parseInt(quantity)
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(`Added ${quantity} x ${currentProduct.name} to cart!`);
                // Use global cart function
                if (window.loadCartItems) {
                    window.loadCartItems();
                }
            }
        });
        
        const modal = bootstrap.Modal.getInstance(document.getElementById('cartModal'));
        modal.hide();
    }
    
    // Load cart on page load
    document.addEventListener('DOMContentLoaded', function() {
        if (window.loadCartItems) {
            window.loadCartItems();
        }
    });
    </script>
@endsection