<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\VoucherController;
use App\Http\Controllers\Admin\DealController;
use App\Http\Controllers\ProductIndexController;
use App\Http\Middleware\AdminMiddleware;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;

/*
|--------------------------------------------------------------------------
| Public Routes
|--------------------------------------------------------------------------
*/

Route::get('/', [ProductIndexController::class, 'index'])->name('home');
Route::get('/product/{id}', [ProductIndexController::class, 'show'])->name('product.show');
Route::get('/search', [ProductIndexController::class, 'search'])->name('search');
Route::get('/api/suggestions', [ProductIndexController::class, 'suggestions'])->name('suggestions');
Route::get('/shop-all', [ProductIndexController::class, 'shopall'])->name('shop-all');
Route::get('/all-store', [ProductIndexController::class, 'allStore'])->name('all-store');
Route::post('/cart/add', [ProductIndexController::class, 'addToCart'])->name('cart.add');
Route::post('/cart/remove', [ProductIndexController::class, 'removeFromCart'])->name('cart.remove');
Route::post('/cart/update', [ProductIndexController::class, 'updateCart'])->name('cart.update');
Route::get('/cart/items', [ProductIndexController::class, 'getCartItems'])->name('cart.items');
Route::get('/shop-checkout', [ProductIndexController::class, 'shopCheckout'])->name('shop-checkout');
Route::post('/place-order', [ProductIndexController::class, 'placeOrder'])->name('place-order');
Route::middleware('auth')->get('/my-orders', [ProductIndexController::class, 'myOrders'])->name('my-orders');
Route::middleware('auth')->post('/notifications/{id}/read', [ProductIndexController::class, 'markNotificationRead'])->name('notifications.read');

Route::middleware('web')->get('/welcome', function () {
    return Inertia::render('Welcome', [
        'canLogin' => Route::has('login'),
        'canRegister' => Route::has('register'),
        'laravelVersion' => Application::VERSION,
        'phpVersion' => PHP_VERSION,
    ]);
});

Route::get('/products', [ProductIndexController::class, 'index'])->name('products.index');

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/

Route::middleware(['auth', AdminMiddleware::class])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::middleware('web')->get('/dashboard', AdminDashboardController::class)
            ->name('dashboard');

        // Resourceful admin routes
        Route::middleware('web')->resource('brands', BrandController::class);
        Route::get('brands/{id}/blockers', [App\Http\Controllers\Admin\BrandController::class, 'blockers'])->name('admin.brands.blockers');
        Route::get('brands/{id}/categories', [App\Http\Controllers\Admin\CategoryController::class, 'categoriesByBrand'])->name('admin.brands.categories');
        Route::middleware('web')->resource('categories', CategoryController::class);
        Route::get('categories/{id}/blockers', [App\Http\Controllers\Admin\CategoryController::class, 'blockers'])->name('admin.categories.blockers');
        Route::middleware('web')->resource('subcategories', App\Http\Controllers\Admin\SubcategoryController::class);
        Route::get('subcategories/{id}/blockers', [App\Http\Controllers\Admin\SubcategoryController::class, 'blockers'])->name('admin.subcategories.blockers');
        Route::middleware('web')->resource('units', App\Http\Controllers\Admin\UnitController::class)->only(['index', 'create', 'store', 'destroy']);
        Route::middleware('web')->resource('roles', App\Http\Controllers\Admin\RoleController::class);
        Route::middleware('web')->resource('users', App\Http\Controllers\Admin\UserController::class);
        Route::middleware('web')->resource('products', ProductController::class);
        Route::post('products/{id}/add-stock', [ProductController::class, 'addStock'])->name('products.add-stock');
        Route::get('stock-history', [ProductController::class, 'stockHistory'])->name('stock-history');
        Route::middleware('web')->resource('orders', OrderController::class);
        Route::get('orders/{id}/invoice', [OrderController::class, 'invoice'])->name('orders.invoice');
        Route::middleware('web')->resource('vouchers', VoucherController::class)->except(['edit', 'update']);
        Route::get('deals/search-products', [DealController::class, 'searchProducts'])->name('deals.search-products');
        Route::middleware('web')->resource('deals', DealController::class);
        Route::middleware('web')->resource('notifications', App\Http\Controllers\Admin\NotificationController::class)->except(['show', 'edit', 'update']);
        Route::resource('reports', ReportController::class)->only(['index']);
        Route::get('reports/stock-history', [ReportController::class, 'stockHistory'])->name('reports.stock-history');
        Route::get('reports/orders-profit', [ReportController::class, 'ordersProfit'])->name('reports.orders-profit');
    });

/*
|--------------------------------------------------------------------------
| User Dashboard
|--------------------------------------------------------------------------
*/

Route::middleware(['web', 'auth', 'verified'])->get('/dashboard', function () {
    $user = Auth::user();
    if ($user && in_array($user->role_id, [2, 3])) {
        return redirect()->route('admin.dashboard');
    }
    return Inertia::render('Dashboard');
})->name('dashboard');

/*
|--------------------------------------------------------------------------
| Profile
|--------------------------------------------------------------------------
*/

Route::middleware(['web', 'auth'])->group(function () {
    Route::middleware('web')->get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::middleware('web')->patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::post('/shipping-addresses', [App\Http\Controllers\ShippingAddressController::class, 'store'])->name('shipping-addresses.store');
    Route::delete('/shipping-addresses/{shippingAddress}', [App\Http\Controllers\ShippingAddressController::class, 'destroy'])->name('shipping-addresses.destroy');
});

require __DIR__ . '/auth.php';
