<?php $__env->startSection('content'); ?>
<main>
    <div class="container my-5">
        <div class="row">
            <div class="col-12">
                <div class="d-flex align-items-center justify-content-between mb-4">
                    <h1 class="h3 mb-0">Your Orders</h1>
                    <div class="d-flex gap-3">
                        <select class="form-select form-select-sm" style="width: auto;">
                            <option>Last 30 days</option>
                            <option>Last 3 months</option>
                            <option>2024</option>
                            <option>2023</option>
                        </select>
                        <input type="search" class="form-control form-control-sm" placeholder="Search all orders" style="width: 250px;">
                    </div>
                </div>

                <?php if($orders->count() > 0): ?>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-4 border">
                        <div class="card-header bg-light py-3">
                            <div class="row align-items-center">
                                <div class="col-md-3">
                                    <div class="small text-muted">ORDER PLACED</div>
                                    <div class="fw-bold"><?php echo e($order->created_at->format('M d, Y')); ?></div>
                                </div>
                                <div class="col-md-2">
                                    <div class="small text-muted">TOTAL</div>
                                    <div class="fw-bold">৳<?php echo e(number_format($order->total_amount, 2)); ?></div>
                                </div>
                                <div class="col-md-3">
                                    <div class="small text-muted">SHIP TO</div>
                                    <div class="fw-bold text-truncate"><?php echo e($order->customer_name); ?></div>
                                </div>
                                <div class="col-md-4 text-end">
                                    <div class="small text-muted">ORDER # <?php echo e($order->order_number); ?></div>
                                    <div class="mt-1">
                                        <a href="#" class="text-decoration-none me-3">View order details</a>
                                        <a href="#" class="text-decoration-none">Invoice</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-center mb-3">
                                        <?php
                                            $statusColor = match($order->status) {
                                                'delivered' => 'success',
                                                'shipped' => 'info',
                                                'processing' => 'warning',
                                                'cancelled' => 'danger',
                                                default => 'secondary'
                                            };
                                        ?>
                                        <span class="badge bg-<?php echo e($statusColor); ?> me-2"><?php echo e(ucfirst($order->status)); ?></span>
                                        <span class="text-muted">
                                            <?php if($order->status == 'delivered'): ?>
                                                Delivered <?php echo e($order->updated_at->format('M d')); ?>

                                            <?php elseif($order->status == 'shipped'): ?>
                                                Shipped <?php echo e($order->updated_at->format('M d')); ?>

                                            <?php else: ?>
                                                <?php echo e(ucfirst($order->status)); ?>

                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    
                                    <?php $__currentLoopData = $order->orderItems->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="me-3">
                                            <?php if($item->product->image): ?>
                                                <img src="<?php echo e(asset('storage/' . $item->product->image)); ?>" 
                                                     alt="<?php echo e($item->product->name); ?>" 
                                                     class="rounded" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="bi bi-image text-muted"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">
                                                <a href="<?php echo e(route('product.show', $item->product->id)); ?>" 
                                                   class="text-decoration-none text-dark">
                                                    <?php echo e($item->product->name); ?>

                                                </a>
                                            </h6>
                                            <div class="small text-muted">Qty: <?php echo e($item->quantity); ?></div>
                                            <div class="small text-muted">৳<?php echo e(number_format($item->price, 2)); ?> each</div>
                                        </div>
                                        <div class="text-end">
                                            <?php if($order->status == 'delivered'): ?>
                                                <button class="btn btn-outline-primary btn-sm mb-1">Buy it again</button>
                                                <br>
                                                <a href="#" class="small text-decoration-none">Write a product review</a>
                                            <?php elseif($order->status == 'shipped'): ?>
                                                <button class="btn btn-outline-secondary btn-sm">Track package</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <?php if($order->orderItems->count() > 3): ?>
                                    <div class="text-muted small">
                                        and <?php echo e($order->orderItems->count() - 3); ?> more items
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-4">
                                    <div class="border-start ps-4">
                                        <h6 class="mb-3">Order Summary</h6>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Items (<?php echo e($order->orderItems->sum('quantity')); ?>):</span>
                                            <span>৳<?php echo e(number_format($order->subtotal, 2)); ?></span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Shipping & handling:</span>
                                            <span>৳0.00</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Tax:</span>
                                            <span>৳0.00</span>
                                        </div>
                                        <hr>
                                        <div class="d-flex justify-content-between fw-bold">
                                            <span>Order total:</span>
                                            <span>৳<?php echo e(number_format($order->total_amount, 2)); ?></span>
                                        </div>
                                        <div class="mt-3">
                                            <div class="small text-muted">Payment method:</div>
                                            <div><?php echo e(ucfirst(str_replace('_', ' ', $order->payment_method))); ?></div>
                                        </div>
                                        <?php if($order->delivery_date): ?>
                                        <div class="mt-2">
                                            <div class="small text-muted">Delivery:</div>
                                            <div><?php echo e(ucfirst($order->delivery_date)); ?> <?php echo e($order->delivery_time); ?></div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($orders->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <div class="mb-4">
                            <i class="bi bi-bag-x display-1 text-muted"></i>
                        </div>
                        <h4>No orders yet</h4>
                        <p class="text-muted">You haven't placed any orders yet. Start shopping to see your orders here.</p>
                        <a href="<?php echo e(route('shop-all')); ?>" class="btn btn-primary">Start Shopping</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wampserver\www\localworks\chefschoicebd\resources\views/myorders.blade.php ENDPATH**/ ?>