
<?php $__env->startSection('content'); ?>
    <main>
        <div class="mt-4">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Stores</li>
                        </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <section class="mt-8">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="bg-light d-flex justify-content-between ps-md-10 ps-6 rounded">
                    <div class="d-flex align-items-center">
                        <h1 class="mb-0 fw-bold">Stores</h1>
                    </div>
                    <div class="py-6">
                        <img src="<?php echo e(asset('assets/images/svg-graphics/store-graphics.svg')); ?>" alt="" class="img-fluid" />
                    </div>
                    </div>
                </div>
            </div>
        </div>
        </section>
        <section class="mt-6 mb-lg-14 mb-8">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="mb-4">
                    <h6>
                        We have
                        <span class="text-primary"><?php echo e($brands->count()); ?></span>
                        stores now
                    </h6>
                    </div>
                </div>
            </div>
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 g-lg-4">
                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col">
                    <div class="card flex-row p-8 card-product">
                    <div>
                        <?php if($brand->logo): ?>
                            <img src="<?php echo e(asset('storage/' . $brand->logo)); ?>" alt="<?php echo e($brand->name); ?>" class="rounded-circle icon-shape icon-xl" />
                        <?php else: ?>
                            <div class="rounded-circle icon-shape icon-xl bg-light d-flex align-items-center justify-content-center">
                                <span class="fw-bold text-primary"><?php echo e(substr($brand->name, 0, 2)); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="ms-6">
                        <h5 class="mb-1"><a href="#!" class="text-inherit"><?php echo e($brand->name); ?></a></h5>
                        <div class="small text-muted">
                            <span><?php echo e($brand->categories_count); ?> Categories</span>
                        </div>
                        <div class="py-3">
                            <ul class="list-unstyled mb-0 small">
                                <li>Quality Products</li>
                                <li>Trusted Brand</li>
                            </ul>
                        </div>
                        <div>
                            <div class="badge text-bg-light border">Available</div>
                        </div>
                    </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        </section>
    </main>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wampserver\www\localworks\chefschoicebd\resources\views/allstore.blade.php ENDPATH**/ ?>