<?php $__env->startSection('content'); ?>
<main>
    <div class="mt-4">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('shop-all')); ?>">Shop</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Checkout</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <section class="mb-lg-14 mb-8 mt-8">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1 class="fw-bold mb-0">Checkout</h1>
                </div>
            </div>

            <form action="<?php echo e(route('place-order')); ?>" method="POST" id="checkoutForm">
                <?php echo csrf_field(); ?>
                <div class="row mt-4">
                    <div class="col-lg-7">
                        
                        <?php if(auth()->guard()->guest()): ?>
                        <!-- Account Information -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-user me-2"></i>Account Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Name *</label>
                                        <input type="text" name="name" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email *</label>
                                        <input type="email" name="email" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Password *</label>
                                        <input type="password" name="password" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Confirm Password *</label>
                                        <input type="password" name="password_confirmation" class="form-control" required>
                                    </div>
                                </div>
                                <input type="hidden" name="guest_registration" value="1">
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Delivery Address -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-map-pin me-2"></i>Delivery Address</h5>
                            </div>
                            <div class="card-body">
                                <?php if(auth()->check() && $addresses->count() > 0): ?>
                                    <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="radio" name="address_id" value="<?php echo e($address->id); ?>" id="address<?php echo e($address->id); ?>" <?php echo e($address->is_default ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="address<?php echo e($address->id); ?>">
                                            <strong><?php echo e($address->first_name); ?> <?php echo e($address->last_name); ?></strong><br>
                                            <?php echo e($address->address_line_1); ?><br>
                                            <?php echo e($address->city); ?>, <?php echo e($address->state); ?>, <?php echo e($address->zip_code); ?>

                                            <?php if($address->phone): ?><br>Phone: <?php echo e($address->phone); ?><?php endif; ?>
                                        </label>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label">First Name *</label>
                                            <input type="text" name="first_name" class="form-control" required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">Last Name *</label>
                                            <input type="text" name="last_name" class="form-control" required>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Address *</label>
                                            <input type="text" name="address" class="form-control" required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">City *</label>
                                            <input type="text" name="city" class="form-control" required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">State *</label>
                                            <input type="text" name="state" class="form-control" required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">Zip Code *</label>
                                            <input type="text" name="zip_code" class="form-control" required>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Phone</label>
                                            <input type="text" name="phone" class="form-control">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Delivery Time -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-clock me-2"></i>Delivery Time</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Delivery Date</label>
                                        <select name="delivery_date" class="form-select">
                                            <option value="today">Today</option>
                                            <option value="tomorrow">Tomorrow</option>
                                            <option value="day_after">Day After Tomorrow</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Time Slot</label>
                                        <select name="delivery_time" class="form-select">
                                            <option value="9am-12pm">9:00 AM - 12:00 PM</option>
                                            <option value="12pm-3pm">12:00 PM - 3:00 PM</option>
                                            <option value="3pm-6pm">3:00 PM - 6:00 PM</option>
                                            <option value="6pm-9pm">6:00 PM - 9:00 PM</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Delivery Instructions -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-message-square me-2"></i>Delivery Instructions</h5>
                            </div>
                            <div class="card-body">
                                <textarea name="delivery_instructions" class="form-control" rows="3" placeholder="Special instructions for delivery (optional)"></textarea>
                            </div>
                        </div>

                        <!-- Payment Method -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-credit-card me-2"></i>Payment Method</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="radio" name="payment_method" value="cash_on_delivery" id="cod" checked>
                                    <label class="form-check-label" for="cod">
                                        <strong>Cash on Delivery</strong><br>
                                        <small class="text-muted">Pay when your order is delivered</small>
                                    </label>
                                </div>
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="radio" name="payment_method" value="bkash" id="bkash">
                                    <label class="form-check-label" for="bkash">
                                        <strong>bKash</strong><br>
                                        <small class="text-muted">Pay using bKash mobile banking</small>
                                    </label>
                                </div>
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="radio" name="payment_method" value="nagad" id="nagad">
                                    <label class="form-check-label" for="nagad">
                                        <strong>Nagad</strong><br>
                                        <small class="text-muted">Pay using Nagad mobile banking</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- Order Summary -->
                    <div class="col-lg-5">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Order Summary</h5>
                            </div>
                            <div class="card-body">
                                <?php $subtotal = 0; ?>
                                <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $subtotal += $item['price'] * $item['quantity']; ?>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <img src="<?php echo e(asset('storage/' . $item['image'])); ?>" alt="<?php echo e($item['name']); ?>" class="img-fluid me-3" style="width: 50px; height: 50px; object-fit: cover;">
                                        <div>
                                            <h6 class="mb-0"><?php echo e($item['name']); ?></h6>
                                            <?php if($item['weight']): ?>
                                            <small class="text-muted"><?php echo e($item['weight']); ?></small>
                                            <?php endif; ?>
                                            <div><small>Qty: <?php echo e($item['quantity']); ?></small></div>
                                        </div>
                                    </div>
                                    <div class="fw-bold">৳<?php echo e(number_format($item['price'] * $item['quantity'], 2)); ?></div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <hr>
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Subtotal:</span>
                                    <span class="fw-bold">৳<?php echo e(number_format($subtotal, 2)); ?></span>
                                </div>
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Delivery Fee:</span>
                                    <span class="fw-bold">Free</span>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <span class="h5">Total:</span>
                                    <span class="h5 fw-bold">৳<?php echo e(number_format($subtotal, 2)); ?></span>
                                </div>
                                
                                <button type="submit" class="btn btn-primary w-100 mt-4">
                                    <i class="feather-icon icon-shopping-bag me-2"></i>Place Order
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
</main>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\wampserver\www\localworks\chefschoicebd\resources\views/shopcheckout.blade.php ENDPATH**/ ?>